<?php
if (!defined('ABSPATH')) exit; // Seguridad

// Ruta de la plantilla
function simnsa_render_login_form() {
    // Si ya está logueado, redirigir al home
    if (isset($_SESSION['simnsa_token'])) {
        wp_redirect(home_url());
        exit;
    }

    ob_start();
    include SIMNSA_PLUGIN_PATH . 'templates/login-form.php';
    return ob_get_clean();
}

// Forzar login en todas las páginas excepto /login
function simnsa_force_login() {
    if (is_user_logged_in() && current_user_can('administrator')) return;

    if (is_page('login')) {
        if (isset($_SESSION['simnsa_token'])) {
            // Ya está logueado, redirigir a /perfil u otra página
            wp_redirect(home_url('/perfil'));
            exit;
        }
        return; // Permitir acceso si no está logueado
    }

    if (!isset($_SESSION['simnsa_token'])) {
        wp_redirect(home_url('/login'));
        exit;
    }
}



// Función para procesar el login
function simnsa_process_login() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['simnsa_login_nonce']) && wp_verify_nonce($_POST['simnsa_login_nonce'], 'simnsa_login')) {
        $username = sanitize_text_field($_POST['username']);
        $password = sanitize_text_field($_POST['password']);

        $response = wp_remote_post('https://data-demo-brokers.simnsa.com/api/v1/Auth/Login', array(
            'headers' => array('Content-Type' => 'application/json'),
            'body' => json_encode(array(
                'username' => $username,
                'password' => $password,
            )),
            'timeout' => 15,
        ));

        if (is_wp_error($response)) {
            echo '<pre>' . print_r($response, true) . '</pre>';
            $_SESSION['simnsa_error'] = 'Error de conexión con el servidor.';
            return;
        }

        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);

        // Mostrar temporalmente la respuesta para depurar
        /**echo '<pre>';
        print_r($data);
        echo '</pre>';**/

        if (!empty($data['accessToken'])) {
            // Login exitoso
            //echo '<p style="color: green;">Login exitoso</p>';

            // Guardar datos en sesión
            $_SESSION['simnsa_token'] = $data['accessToken'];
            $_SESSION['simnsa_refresh'] = $data['refreshToken'];

            // Puedes guardar más datos si quieres
            $_SESSION['simnsa_broker'] = array(
                'id' => $data['idBroker'],
                'name' => $data['name'],
            );

            // Redirigir al home
            wp_redirect(home_url());
            exit;
        }
    }
}

add_action('init', 'simnsa_process_login');

// Iniciar sesión PHP si no está activa
add_action('init', function () {
    if (!session_id()) {
        session_start();
    }
});
